<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDynamicFieldsTable extends Migration
{
    public function up()
    {
        Schema::create('dynamic_fields', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // نام فیلد (مثلاً "تعداد", "نوع رنگ" و...)
            $table->string('slug')->unique(); // اسلاگ یکتا برای فیلد
            $table->text('description')->nullable();
            $table->string('field_type'); // نوع فیلد: text, number, select, radio, textarea و غیره
            $table->json('options')->nullable(); // گزینه‌ها در صورت select یا radio، به صورت آرایه JSON
            $table->unsignedBigInteger('category_id')->nullable(); // اتصال به دسته اصلی
            $table->unsignedBigInteger('parent_id')->nullable(); // اتصال به زیر دسته (اختیاری)
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();

            // کلیدهای خارجی
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->foreign('parent_id')->references('id')->on('categories')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('dynamic_fields');
    }
}
