<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTicketAttachmentsTable extends Migration
{
    public function up()
    {
        Schema::create('ticket_attachments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('ticket_id');           // اضافه کردن ستون ticket_id
            $table->unsignedBigInteger('ticket_reply_id');
            $table->string('file_path');
            $table->string('file_type')->nullable();
            $table->timestamps();
           // تعریف کلید خارجی ticket_id به جدول tickets
           $table->foreign('ticket_id')->references('id')->on('tickets')->onDelete('cascade');

           // کلید خارجی ticket_reply_id به جدول ticket_replies
          $table->foreign('ticket_reply_id')->references('id')->on('ticket_replies')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('ticket_attachments');
    }
};

