<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBankAccountsTable extends Migration
{
    public function up()
    {
        Schema::create('bank_accounts', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            $table->string('bank_name')->nullable();
            $table->string('card_number')->nullable();
            $table->string('bank_account')->nullable();
            $table->string('sheba')->nullable();
            $table->string('iban')->nullable();
            $table->string('account_holder_name')->nullable();

            $table->enum('status', ['active', 'inactive'])->default('inactive');

            $table->timestamp('activated_at')->nullable();
            $table->timestamp('deactivated_at')->nullable();
            $table->string('currency')->nullable();


            $table->timestamps();  // این دو ستون created_at و updated_at را با تنظیمات درست می‌سازد
        });
    }

    public function down()
    {
        Schema::dropIfExists('bank_accounts');
    }
}
