<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserVerificationsTable extends Migration
{
    public function up()
    {
        Schema::create('user_verifications', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->constrained()->onDelete('cascade');


            $table->enum('profile_status', ['pending', 'approved', 'rejected'])->default('pending');

            $table->string('national_card_image')->nullable();
            $table->string('selfie_image')->nullable();

            $table->enum('national_card_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->enum('selfie_status', ['pending', 'approved', 'rejected'])->default('pending');

            $table->timestamp('national_card_verified_at')->nullable();
            $table->timestamp('selfie_verified_at')->nullable();
            $table->timestamp('profile_verified_at')->nullable();

            $table->text('notes')->nullable(); // اگر بخواهی یادداشت یا توضیح اضافه کنی

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('user_verifications');
    }
}
