<?php

namespace App\Services\verify;

use App\Models\User;
use App\Models\UserVerification;
use Carbon\Carbon;

class VerifyUserService
{
    protected $zibalService;

    public function __construct(ZibalService $zibalService)
    {
        $this->zibalService = $zibalService;
    }

    public function verify(int $userId): array
{
    $user = User::find($userId);

    if (!$user) {
        return ['status' => 'error', 'message' => 'کاربر یافت نشد.'];
    }

    $nationalCode = $user->national_code;
    $birthDate = $user->birthdate;
    $mobile = $user->mobile;

    if (!$nationalCode || !$birthDate || !$mobile) {
        return ['status' => 'error', 'message' => 'اطلاعات هویتی کافی موجود نیست.'];
    }

    try {
        $this->zibalService->verifyNationalIdentity($nationalCode, $birthDate);
        $this->zibalService->verifyMobileWithShahkar($nationalCode, $mobile);

        UserVerification::updateOrCreate(
            ['national_code' => $nationalCode],
            [
                'user_id' => $userId,
                'mobile' => $mobile,
                'profile_status' => 'approved',
                'profile_verified_at' => Carbon::now(),
            ]
        );

        // آپدیت user_level کاربر به 1
        if ($user->user_level < 1) {
            $user->user_level = 1;
            $user->save();
        }

        return ['status' => 'success', 'message' => 'اعتبارسنجی کاربر با موفقیت انجام شد.'];
    } catch (\Exception $e) {
        return ['status' => 'error', 'message' => $e->getMessage()];
    }
  }
}
