<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VirtualProduct extends Model
{
    protected $fillable = [
        'item_id',
        'username',
        'password',
        'license_key',
        'description',
        'is_active',
        'is_sold',
    ];

    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class);
    }
}
