<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserApi extends Model
{
    protected $table = 'users_api';

    protected $fillable = [
        'user_id',
        'api_key',
        'number_hour',
        'number_month',
        'is_active',
    ];

    public $timestamps = true;

    /**
     * رابطه با مدل User
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
