<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'wallet_id',
        'type', // deposit, withdraw, transfer, exchange
        'amount',
        'amount_usd', // معادل دلاری برای گزارش و محاسبات
        'status', // pending, completed, failed
        'transaction_hash', // هش تراکنش در بلاکچین (اگر کریپتو)
        'reference_id', // شناسه مرجع داخلی (مثلاً سفارش تبدیل)
        'details', // اطلاعات اضافی یا توضیحات
    ];

    protected $casts = [
        'amount' => 'decimal:18',
        'amount_usd' => 'decimal:18',
    ];

    public function wallet()
    {
        return $this->belongsTo(Wallet::class);
    }
}
