<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Item extends Model
{
    protected $fillable = [
        'category_id',
        'title',
        'slug',
        'short_description',
        'full_description',
        'is_active',
        'currency_type',
        'service_fee_percent',
        'tax_percent',
        'type',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'og_title',
        'og_description',
        'og_image',
        'twitter_title',
        'twitter_description',
        'twitter_image',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    // رابطه با محصولات مجازی (licenses و... به عنوان مثال)
    public function virtualProducts(): HasMany
    {
        return $this->hasMany(VirtualProduct::class);
    }

    // رابطه با فیلدهای داینامیک (از دسته مرتبط خودش می‌گیرد ولی اگر نیاز باشه میشه فیلد جدا هم اضافه کرد)
    public function dynamicFields(): HasMany
    {
        return $this->hasMany(DynamicField::class);
    }
}
