<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = [
        'user_id',
        'item_id',
        'quantity',
        'unit_price',
        'total_price',
        'payment_status',
        'order_status',
        'order_number',
        'request_type',
        'payment_date',
        'currency_price_at_purchase',
        'service_fee_percent',
        'tax_percent',
        'payment_image_path',
    ];

    // روابط
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function item()
    {
        return $this->belongsTo(Item::class);
    }
}
