<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Currency extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'name_fa',
        'symbol',
        'type',            // 'crypto' یا 'fiat'
        'blockchain',      // برای کریپتو
        'coin_type',       // 'coin' یا 'token'
        'decimals',
        'description',     // توضیحات ارز
        'current_price',   // قیمت فعلی به دلار
        'price_low_24h',   // کمترین قیمت 24 ساعت گذشته
        'price_high_24h',  // بیشترین قیمت 24 ساعت گذشته
        'price_low_1h',    // کمترین قیمت 1 ساعت گذشته
        'price_high_1h',   // بیشترین قیمت 1 ساعت گذشته
        'price_change_24h',// تغییر قیمت 24 ساعته (درصد)
        'price_change_1h', // تغییر قیمت 1 ساعته (درصد)
        'market_cap',      // مارکت کپ دلار
        'volume_24h',      // حجم معاملات 24 ساعته
        'circulating_supply', // تعداد در گردش
        'total_supply',       // تعداد کل
        'is_active',
        'is_essential', //ضروری هستش یا نه
        'api_source',
        'api_id',
        'sort_order', // ردیف نمایش تو لیست ها
        'update_error',
    ];

    protected $casts = [
        'decimals' => 'integer',
        'current_price' => 'decimal:18',
        'price_low_24h' => 'decimal:18',
        'price_high_24h' => 'decimal:18',
        'price_low_1h' => 'decimal:18',
        'price_high_1h' => 'decimal:18',
        'price_change_24h' => 'float',
        'price_change_1h' => 'float',
        'market_cap' => 'decimal:18',
        'volume_24h' => 'decimal:18',
        'circulating_supply' => 'decimal:18',
        'total_supply' => 'decimal:18',
        'is_active' => 'boolean',
    ];
}
