<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'page_text',
        'page_image',
        'parent_id',
        'is_active',
        'sort_order',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'og_title',
        'og_description',
        'og_image',
        'twitter_title',
        'twitter_description',
        'twitter_image',
    ];

    // رابطه والد (parent)
    public function parent(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    // رابطه آیتم‌ها
    public function items(): HasMany
    {
        return $this->hasMany(Item::class);
    }

    // رابطه فیلدهای داینامیک
    public function dynamicFields(): HasMany
    {
        return $this->hasMany(DynamicField::class);
    }

    public function children(): HasMany
{
    return $this->hasMany(Category::class, 'parent_id')->with('children');
}
}
