<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApiRequest extends Model
{
    protected $table = 'api_requests';

    protected $fillable = [
        'user_api_id',
        'method',
        'url',
        'success',
        'request_body',
        'response_body',
    ];

    public function userApi()
    {
        return $this->belongsTo(UserApi::class, 'user_api_id');
    }
}
