<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VerifyUserRequest extends FormRequest
{
    public function authorize()
    {
        return true; // یا بر اساس لاگین و دسترسی تغییر بده
    }

    public function rules()
    {
        return [
            'user_id' => 'required|integer|exists:users,id',
        ];
    }

    public function messages()
    {
        return [
            'user_id.required' => 'شناسه کاربر الزامی است.',
            'user_id.integer' => 'شناسه کاربر باید عدد باشد.',
            'user_id.exists' => 'کاربر با این شناسه یافت نشد.',
        ];
    }
}
