<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VerifyOtpRequest extends FormRequest
{
    public function authorize()
    {
        return true;  // اجازه دسترسی به همه
    }

    public function rules()
    {
        return [
            'mobile' => ['required', 'digits:11', 'regex:/^09[0-9]{9}$/'],
            'otp_code' => ['required', 'digits:6'],
        ];
    }

    public function messages()
    {
        return [
            'mobile.required' => 'شماره موبایل الزامی است.',
            'mobile.digits' => 'شماره موبایل باید 11 رقم باشد.',
            'mobile.regex' => 'شماره موبایل نامعتبر است.',
            'otp_code.required' => 'کد تایید الزامی است.',
            'otp_code.digits' => 'کد تایید باید 6 رقمی باشد.',
        ];
    }
}
