<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class TicketStoreRequest extends FormRequest
{
    public function authorize()
    {
        return true; // یا اگر نیاز هست بررسی احراز هویت اضافه کن
    }

    public function rules()
    {
        return [
            'department_id' => ['required', 'exists:ticket_departments,id'],
            'priority_id' => ['required', 'exists:ticket_priorities,id'],
            'subject' => ['required', 'string', 'max:255'],
            'description' => ['required', 'string'],
            'assigned_to' => ['nullable', 'exists:users,id'],
            'attachments.*' => ['nullable', 'file', 'max:10240'], // حداکثر 10 مگابایت، می‌توان محدودیت پسوند هم اضافه کرد
        ];
    }

    public function messages()
    {
        return [
            'department_id.required' => 'انتخاب دپارتمان الزامی است.',
            'department_id.exists' => 'دپارتمان انتخاب شده معتبر نیست.',
            'priority_id.required' => 'انتخاب اولویت الزامی است.',
            'priority_id.exists' => 'اولویت انتخاب شده معتبر نیست.',
            'subject.required' => 'موضوع تیکت الزامی است.',
            'subject.max' => 'موضوع نمی‌تواند بیشتر از ۲۵۵ کاراکتر باشد.',
            'description.required' => 'توضیحات تیکت الزامی است.',
            'attachments.*.file' => 'فایل ضمیمه معتبر نیست.',
            'attachments.*.max' => 'حجم فایل ضمیمه نباید بیشتر از ۱۰ مگابایت باشد.',
        ];
    }
    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}
