<?php

namespace App\Http\Controllers\dashboard\ticket;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Services\ticket\TicketService;
use App\Http\Requests\TicketStoreRequest;
use App\Http\Requests\TicketReplyStoreRequest;
use App\Services\ticket\TicketReplyService;
use Auth;
class TicketController extends Controller
{
    protected $ticketService;
    protected $ticketReplyService;
    public function __construct(TicketService $ticketService,TicketReplyService $ticketReplyService)
    {
        $this->ticketService = $ticketService;
        $this->ticketReplyService = $ticketReplyService;
    }


       public function store(TicketStoreRequest $request): JsonResponse
    {
        $user = Auth::user();

        $ticket = $this->ticketService->createTicket(
            $user->id,
            $request->only(['department_id', 'priority_id', 'subject', 'description', 'assigned_to']),
            $request->file('attachments')
        );

        return response()->json([
            'status' => 'success',
            'message' => 'تیکت با موفقیت ایجاد شد.',
            'data' => $ticket->load(['department', 'priority', 'attachments']),
        ]);
    }

    public function replies(TicketReplyStoreRequest $request): JsonResponse
    {
        $user = auth()->user();

        $reply = $this->ticketReplyService->createReply(
            $user->id,
            $request->only(['ticket_id', 'message']),
            $request->file('attachments')
        );

        return response()->json([
            'status' => 'success',
            'message' => 'پاسخ تیکت با موفقیت ثبت شد.',
            'data' => $reply->load(['attachments']),
        ]);
    }
}
