<?php

namespace App\Http\Controllers\Dashboard\Bank;
use App\Http\Controllers\Controller;
use App\Http\Requests\BankAccountRequest;
use App\Services\bank\BankAccountService;
use Illuminate\Http\Request;
class BankController extends Controller
{
    protected $bankAccountService;

    public function __construct(BankAccountService $bankAccountService)
    {
        $this->bankAccountService = $bankAccountService;
    }

    public function addBank(BankAccountRequest $request)
    {
        $result = $this->bankAccountService->handleBankAccount($request->validated());

        if ($result['status'] === 'error') {
            return response()->json([
                'status' => 'error',
                'message' => $result['message']
            ], 422);
        }

        return response()->json([
            'status' => 'success',
            'message' => $result['message'],
            'data' => $result['data']
        ]);
    }

    public function ss()
    {
        return 100;
    }
}
