<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Jobs\UpdateCryptoPricesJob;
class CurrencyController extends Controller
{
    /**
     * نمایش لیست ارزهای فعال به همراه قیمت‌ها
     *
     * @return JsonResponse
     */

    public function crypto_list(Request $request): JsonResponse
    {
        // تعداد آیتم در هر صفحه (قابل تنظیم توسط کوئری پارامتر ?per_page=20)
        $perPage = $request->query('per_page', 20);

        $currencies = Currency::where('is_active', true)
            ->where('type', 'crypto')
            ->select('id', 'name', 'symbol', 'current_price', 'price_change_24h', 'market_cap')
            ->orderByDesc('market_cap')
            ->paginate($perPage);

        return response()->json([
            'status' => 'success',
            'data' => $currencies->items(),
            'pagination' => [
                'current_page' => $currencies->currentPage(),
                'per_page' => $currencies->perPage(),
                'total' => $currencies->total(),
                'last_page' => $currencies->lastPage(),
            ],
        ]);
    }

    public function updatePrices(Request $request)
    {
        // جاب رو dispatch میکنیم (تو صف قرار میدیم)
        UpdateCryptoPricesJob::dispatch();


        return response()->json([
            'message' => 'Job dispatched successfully'
        ]);
    }
}
