<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\Ticket\TicketController;
use App\Http\Middleware\ApiKeyRateLimit;

Route::middleware(ApiKeyRateLimit::class)->group(function () {
    Route::middleware('auth:sanctum')->post('dashboard/ticket/add', [TicketController::class, 'store']);
    Route::middleware('auth:sanctum')->post('dashboard/ticket/lists', [TicketController::class, 'getUserTickets']);
    Route::middleware('auth:sanctum')->post('dashboard/tickets/{id}', [TicketController::class, 'showTicket']);
    Route::middleware('auth:sanctum')->post('dashboard/ticket/replies', [TicketController::class, 'replies']);
    Route::middleware('auth:sanctum')->post('dashboard/tickets/{id}/closed', [TicketController::class, 'closedTicket']);
});
