<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Dashboard\Bank\BankController;
use App\Http\Middleware\CheckUserLevel;
use App\Http\Middleware\ApiKeyRateLimit;


//Route::middleware('auth:sanctum')->post('/dashboard/ticket/add', [BankController::class, 'addBank']);
//Route::get('/dashboard/bank/list', [BankController::class, 'getUserBankAccounts'])->middleware(CheckUserLevel::class . ':1');

Route::middleware(ApiKeyRateLimit::class)->group(function () {
     Route::middleware('auth:sanctum')->post('/dashboard/bank/add', [BankController::class, 'addBank'])->middleware(CheckUserLevel::class . ':1');
     Route::middleware('auth:sanctum')->get('/dashboard/bank/list', [BankController::class, 'getUserBankAccounts']);
});
