<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('wallet_id'); // ارتباط با کیف پول
            $table->string('transaction_type'); // نوع تراکنش: deposit, withdraw, transfer و ...
            $table->string('payment_system'); // سیستم پرداخت: blockchain, online , card_to_card و ...
            $table->string('blockchain_name')->nullable(); // نام بلاکچین در صورت وجود
            $table->string('status')->default('pending'); // وضعیت: pending, approved, canceled و ...
            $table->string('external_id')->nullable(); // شناسه تراکنش خارجی (txid، فاکتور و ...)
            $table->decimal('amount', 24, 8); // مبلغ تراکنش، دقت بالا برای ارزهای دیجیتال
            $table->decimal('total_amount', 24, 8); // مبلغ تراکنش، دقت بالا برای ارزهای دیجیتال
            $table->string('currency'); // واحد پول یا ارز: IRR, USD, ETH و ...
            $table->text('description')->nullable(); // توضیحات اختیاری
            $table->longText('metadata')->nullable(); // اطلاعات اضافی در قالب JSON
            $table->unsignedBigInteger(column: 'bank_account_id')->nullable();

            $table->timestamps();

            // کلیدهای خارجی
            $table->foreign('wallet_id')->references('id')->on('wallet_internal')->onDelete('cascade');
            $table->foreign('bank_account_id')->references('id')->on('bank_accounts')->onDelete('set null');

            // ایندکس‌های پرکاربرد
            $table->index('transaction_type');
            $table->index('status');
            $table->index('payment_system');
        });
    }

    public function down()
    {
        Schema::dropIfExists('transactions');
    }


}
