<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoriesTable extends Migration
{
    public function up()
    {
        Schema::create('categories', function (Blueprint $table) {
    $table->id();

    $table->string('name');
    $table->string('slug')->unique();
    $table->text('description')->nullable();

    $table->unsignedBigInteger('parent_id')->nullable();
    $table->unsignedBigInteger('page_id')->nullable();

    $table->boolean('is_active')->default(true);
    $table->integer('sort_order')->default(0);

    $table->timestamps();

    // کلید خارجی والد دسته‌بندی
    $table->foreign('parent_id')->references('id')->on('categories')->onDelete('cascade');

    // کلید خارجی صفحه مرتبط
    $table->foreign('page_id')->references('id')->on('pages')->onDelete('set null')->onUpdate('cascade');
});
    }

    public function down()
    {
        Schema::dropIfExists('categories');
    }
}
