<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagesTable extends Migration
{
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();

            // اطلاعات پایه
            $table->string('title');                    // عنوان برگه
            $table->string('slug')->unique();           // اسلاگ برای url
            $table->string('short_description')->nullable();  // توضیحات کوتاه
            $table->longText('content')->nullable();          // محتوای کامل برگه (html یا markdown)

            // وضعیت نمایش
            $table->boolean('is_active')->default(true);

            // بازدیدها
            $table->unsignedBigInteger('views')->default(0);

            // تصاویر (مسیر ذخیره‌سازی فایل)
            $table->string('thumbnail')->nullable();    // تصویر کوچک
            $table->string('featured_image')->nullable(); // تصویر اصلی
            $table->string('logo')->nullable();         // لوگو مخصوص برگه

            // تاریخچه
            $table->timestamps();
            $table->softDeletes();  // حذف نرم (soft delete)
        });
    }

    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
