<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApiRequestsTable extends Migration
{
    public function up()
    {
        Schema::create('api_requests', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_api_id')->nullable(); // ارجاع به users_api (کلید api)
            $table->string('method', 10); // GET, POST, ...
            $table->string('url'); // آدرس درخواست شده (full URL)
            $table->boolean('success')->default(true); // وضعیت موفقیت درخواست
            $table->text('request_body')->nullable(); // محتوای ریکوست (مثلا برای POST)
            $table->text('response_body')->nullable(); // پاسخ دریافتی یا خطا (اختیاری)
            $table->timestamps();

            $table->foreign('user_api_id')->references('id')->on('users_api')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('api_requests');
    }
};
