<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('users_api', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // ارجاع به جدول users
            $table->string('api_key')->unique();
            $table->unsignedInteger('number_hour')->default(100);   // محدودیت تعداد درخواست در ساعت
            $table->unsignedInteger('number_month')->default(1000); // محدودیت تعداد درخواست در ماه
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users_api');
    }
};
