<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWalletsTable extends Migration
{
    public function up()
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();

            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('currency_id')->constrained()->onDelete('cascade');

            $table->enum('type', ['fiat', 'crypto'])->default('crypto');
            $table->string('blockchain')->nullable();
            $table->enum('coin_type', ['coin', 'token'])->nullable();

            $table->string('address')->unique();
            $table->text('private_key')->nullable();
            $table->text('public_key')->nullable();
            $table->text('security_field')->nullable();

            $table->decimal('balance', 30, 18)->default(0);
            $table->decimal('balance_frozen', 30, 18)->default(0);

            $table->boolean('is_active')->default(true);

            $table->boolean('is_essential')->default(false);
            $table->timestamps();

            $table->index(['user_id', 'currency_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('wallets');
    }
}
