<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCurrenciesTable extends Migration
{
    public function up()
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->id();

            $table->string('name');
			$table->string('name_fa')->nullable();
            $table->string('symbol')->unique();
            $table->enum('type', ['crypto', 'fiat'])->default('crypto');
            $table->string('blockchain')->nullable();
            $table->enum('coin_type', ['coin', 'token'])->nullable();
            $table->unsignedTinyInteger('decimals')->default(8);

            $table->text('description')->nullable();

            $table->decimal('min_withdraw', 5, places: 2)->default(0);
            $table->decimal('withdraw_fee', 5, places: 2)->default(0);
            $table->decimal('current_price', 30, 18)->default(0);
            $table->decimal('price_low_24h', 30, 18)->nullable();
            $table->decimal('price_high_24h', 30, 18)->nullable();
            $table->decimal('price_low_1h', 30, 18)->nullable();
            $table->decimal('price_high_1h', 30, 18)->nullable();

            $table->float('price_change_24h')->nullable();
            $table->float('price_change_1h')->nullable();

            $table->decimal('market_cap', 30, 8)->nullable();
            $table->decimal('volume_24h', 30, 18)->nullable();

            $table->decimal('circulating_supply', 30, 18)->nullable();
            $table->decimal('total_supply', 30, 18)->nullable();

            $table->boolean('is_active')->default(true);

            $table->string('api_source')->nullable();
            $table->string('api_id')->nullable();

            $table->decimal('sort_order')->nullable();

            $table->text('update_error')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('currencies');
    }
}
