<?php

namespace App\Services\user;

use App\Models\UserLogin;
use Illuminate\Support\Facades\Auth;

class UserLoginService
{
    public function getUserLogins(int $userId)
    {
        return UserLogin::where('user_id', $userId)
            ->orderBy('last_active_at', 'desc')
            ->get();
    }

    public function logoutOtherDevices(int $userId, int $currentLoginId)
    {
        return UserLogin::where('user_id', $userId)
            ->where('id', '!=', $currentLoginId)
            ->delete();
    }
}
