<?php

namespace App\Services\transaction;

use App\Models\Transaction;
use Illuminate\Database\Eloquent\Builder;

class TransactionReportService
{
    public function getAllTransactions()
    {
        return Transaction::orderBy('created_at', 'desc')->get();
    }

    public function getTransactionsByWalletId(int $walletId)
    {
        return Transaction::where('wallet_id', $walletId)
            ->orderBy('created_at', 'desc')
            ->get();
    }

    public function getTransactionsByCurrency(string $currency)
    {
        return Transaction::where('currency', $currency)
            ->orderBy('created_at', 'desc')
            ->get();
    }

    public function filterTransactions(array $filters)
    {
        $query = Transaction::query();

        if (!empty($filters['currency'])) {
            $query->where('currency', $filters['currency']);
        }

        if (!empty($filters['transaction_type'])) {
            $query->where('transaction_type', $filters['transaction_type']);
        }

        if (!empty($filters['date_from'])) {
            $query->whereDate('created_at', '>=', $filters['date_from']);
        }

        if (!empty($filters['date_to'])) {
            $query->whereDate('created_at', '<=', $filters['date_to']);
        }

        return $query->orderBy('created_at', 'desc')->get();
    }
}
