<?php

namespace App\Services\ticket;

use App\Models\Ticket;
use App\Models\TicketAttachment;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;

class TicketService
{
     public function createTicket(int $userId, array $data, ?array $attachments = null): Ticket
    {
        return DB::transaction(function () use ($userId, $data, $attachments) {
            $ticket = Ticket::create([
                'user_id' => $userId,
                'department_id' => $data['department_id'],
                'priority_id' => $data['priority_id'],
                'subject' => $data['subject'],
                'description' => $data['description'],
                'status' => 'new', // وضعیت اولیه
                'assigned_to' => $data['assigned_to'] ?? null,
            ]);

            if ($attachments) {
                foreach ($attachments as $file) {
                    $path = $file->store('ticket_attachments');

                    $ticket->attachments()->create([
                        'file_path' => $path,
                        'file_name' => $file->getClientOriginalName(),
                        'mime_type' => $file->getClientMimeType(),
                        'file_size' => $file->getSize(),
                    ]);
                }
            }

            return $ticket;
        });
    }

    public function getUserTickets(int $userId, ?string $priority = null)
    {
    $query = Ticket::with(['department', 'priority'])
        ->where('user_id', $userId);

    if ($priority) {
        $query->whereHas('priority', function ($q) use ($priority) {
            $q->where('name', $priority);
        });
    }

    return $query->orderBy('created_at', 'desc')->get();
    }


    public function getTicketByIdAndUser(int $ticketId, int $userId)
    {
        return Ticket::with(['replies', 'department', 'priority'])
            ->where('id', $ticketId)
            ->where('user_id', $userId)
            ->first();
    }


}
