<?php
namespace App\Services\shared\item;

use App\Models\Category;
use App\Models\Item;
use App\Models\DynamicField;
class ItemService
{
     public function getItemBySlug(string $slug)
    {
            $item = Item::with(['category', 'seoMetadata'])
        ->where('slug', $slug)
        ->where('is_active', true)
        ->first();

    if (!$item) {
        return null;
    }

    // گرفتن فیلدهای داینامیک با شرط OR برای slug و category_id
    $dynamicFields = DynamicField::where(function ($query) use ($item) {
        $query->where('slug', $item->slug)
            ->orWhere(function ($query) use ($item) {
                $query->whereNotNull('category_id')
                      ->where('category_id', $item->category_id);
            });
    })->get()->map(function($field) {
        return [
             'id' => $field->id,
             'name' => $field->name,
             'description' => $field->description,
             'options' => $field->options,
             'field_type' => $field->field_type,
             'sort_order' => $field->sort_order,
            // اگر مقدار داری جداگانه کوئری بزنی و اضافه کنی
        ];
    });

    // آماده‌سازی داده‌های محصول
    $itemData = $item->only([
        'id', 'title', 'slug', 'short_description', 'full_description',
        'is_active', 'price', 'currency_type', 'service_fee_percent', 'tax_percent',
        'type', 'is_featured', 'category_id'
    ]);

    return [
        'item' => $itemData,
        'category' => $item->category,
        'seo' => $item->seoMetadata,
        'dynamic_fields' => $dynamicFields,
    ];
    }

    public function getFeaturedItem()
    {
        return Item::where('is_active', true)
            ->where('is_featured', true)
            ->orderBy('id', 'desc')
            ->get(['id', 'title', 'slug', 'short_description', 'price','currency_type', 'category_id']);
    }

    public function getProductsByCategorySlug(string $slug)
    {
          $category = Category::where('slug', $slug)->first();

        if (!$category) {
            return collect();
        }

        if ($category->parent_id) {
            // زیر دسته هست فقط محصولات خودش
            return Item::where('category_id', $category->id)
                ->where('is_active', true)
                ->get(['id', 'title','slug', 'price','currency_type']);
        } else {
            // دسته اصلی هست، محصولات خودش و تمام زیر دسته‌های مستقیم
            $subCategoryIds = Category::where('parent_id', $category->id)->pluck('id')->toArray();

            $categoryIds = array_merge([$category->id], $subCategoryIds);

            return Item::whereIn('category_id', $categoryIds)
                ->where('is_active', true)
                ->get(['id', 'title','slug', 'price','currency_type']);
        }
    }
}
