<?php

namespace App\Services\shared\category;

use App\Models\Category;

class CategoryService
{
    public function getCategoryPageWithSeo(string $slug): ?array
    {
        $category = Category::with([
            'seoMetadata',
            'page.seoMetadata',
            'page.fields.values'
        ])->where('slug', $slug)->first();

        if (!$category) {
            return null;
        }

        $categoryData = $category->only([
            'id', 'name', 'slug', 'description', 'parent_id', 'is_active', 'sort_order',
        ]);

        // اطلاعات SEO دسته‌بندی
        $seo_category = $category->seoMetadata;
        $categorySeoData = $seo_category ? [
            'meta_title' => $seo_category->meta_title,
            'meta_description' => $seo_category->meta_description,
            'meta_keywords' => $seo_category->meta_keywords,
            'og_title' => $seo_category->og_title,
            'og_description' => $seo_category->og_description,
            'og_image' => $seo_category->og_image,
            'twitter_title' => $seo_category->twitter_title,
            'twitter_description' => $seo_category->twitter_description,
            'twitter_image' => $seo_category->twitter_image,
        ] : null;

        // اطلاعات صفحه
        $page = $category->page;
        $pageData = $page ? $page->only([
            'title', 'slug', 'short_description', 'content', 'is_active', 'views',
            'thumbnail', 'featured_image', 'logo',
        ]) : null;



        // فیلدهای داینامیک صفحه به همراه مقادیر
        $dynamicFields = [];
        if ($page && $page->fields) {
            foreach ($page->fields as $field) {
                $values = $field->values->pluck('value')->all();
                $dynamicFields[] = [
                    'id' => $field->id,
                    'name' => $field->name,
                    'type' => $field->type,
                    'values' => $values,
                ];
            }
        }

        return [
            'category' => $categoryData,
            'page' => $pageData,
            'page_seo' => $categorySeoData,
            'page_dynamic_fields' => $dynamicFields,
        ];
    }
}
