<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WalletInternal extends Model
{
    protected $table = 'wallet_internal'; // یا هر نام صحیح
    protected $fillable = [
        'user_id',
        'currency_id',
        'type', // 'fiat' یا 'crypto'
        'address',
        'balance',
        'balance_frozen',
        'is_active',
		'is_essential',
    ];

    protected $casts = [
        'balance' => 'decimal:18',
        'balance_frozen' => 'decimal:18',
        'is_active' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
}
