<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    protected $fillable = [
        'user_id',
        'currency_id',
        'type', // 'fiat' یا 'crypto'
        'blockchain', // فقط برای کریپتو
        'coin_type', // 'coin' یا 'token' فقط برای کریپتو
        'address',
        'private_key',
        'public_key',
        'security_field',
        'balance',
        'balance_frozen',
        'is_active',
		'is_essential',
    ];

    protected $casts = [
        'balance' => 'decimal:18',
        'balance_frozen' => 'decimal:18',
        'is_active' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
}
