<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'email_verified_at',
        'mobile',
        'mobile_verified_at',
        'otp_code',
        'otp_code_expires_at',
        'otp_attempts',
        'password',
        'national_code',
        'birthdate',
        'address',
        'city',
        'country',
        'postal_code',
        'is_active',
        'is_admin',
        'user_level',
        'two_factor_enabled',
    ];

    protected $hidden = [
        'password',
        'remember_token',
        'otp_code',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'mobile_verified_at' => 'datetime',
        'otp_code_expires_at' => 'datetime',
        'birthdate' => 'date',
        'is_active' => 'boolean',
        'is_admin' => 'boolean',
        'two_factor_enabled' => 'boolean',
    ];

    public function setPasswordAttribute($password)
    {
        if ($password) {
            $this->attributes['password'] = bcrypt($password);
        }
    }

    public function isMobileVerified()
    {
        return !is_null($this->mobile_verified_at);
    }

    public function generateSmsVerificationCode()
    {
        $this->otp_code = rand(100000, 999999);
        $this->otp_code_expires_at = now()->addMinutes(5);
        $this->save();

        return $this->otp_code;
    }

    public function verifySmsCode($code)
    {
        if ($this->otp_code === $code && $this->otp_code_expires_at > now()) {
            $this->mobile_verified_at = now();
            $this->otp_code = null;
            $this->otp_code_expires_at = null;
            $this->save();

            return true;
        }
        return false;
    }

    public function logins()
    {
        return $this->hasMany(UserLogin::class);
    }
}
