<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $fillable = [
        'wallet_id',
        'bank_account_id',
        'transaction_type',
        'payment_system',
        'blockchain_name',
        'status',
        'external_id',
        'amount',
        'total_amount',
        'currency',
        'description',
        'metadata',
    ];

    protected $casts = [
        'metadata' => 'array',
        'amount' => 'decimal:8',
    ];

    public function wallet()
    {
        return $this->belongsTo(WalletInternal::class);
    }
}
