<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BankAccount extends Model
{
    protected $table = 'bank_accounts';

    protected $fillable = [
        'user_id',
        'bank_name',
        'card_number',
        'bank_account',
        'sheba',
        'iban',
        'account_holder_name',
        'currency',
        'status',
        'activated_at',
        'deactivated_at',
    ];

    // ارتباط به مدل User
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
