<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserBankAccountRequest extends FormRequest
{
    public function authorize()
    {
        return true; // اگر همه اجازه دارن، true بذار. در صورت نیاز لاگیک خاص بذار.
    }

    public function rules()
    {
        return [
            'currency_type' => 'required|string',
        ];
    }

      protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        throw new \Illuminate\Validation\ValidationException($validator, response()->json([
            'status' => 'error',
            'errors' => $validator->errors()
        ], 422));
    }
}
