<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SendOtpRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
{
    return [
        'mobile' => ['required', 'digits:11', 'regex:/^09[0-9]{9}$/'],
    ];
}

public function messages()
{
    return [
        'mobile.required' => 'شماره موبایل الزامی است.',
        'mobile.digits' => 'شماره موبایل باید 11 رقم باشد.',
        'mobile.regex' => 'شماره موبایل نامعتبر است.',
    ];
}

}
