<?php

namespace App\Http\Controllers\Dashboard\Verify;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use App\Models\UserVerification;
use Illuminate\Support\Facades\Auth;
use App\Services\verify\ZibalService;
use App\Models\User;
use App\Http\Requests\VerifyUserRequest;
use App\Services\verify\VerifyUserService;
class VerifyController extends Controller
{
    protected $zibalService;
    protected $verifyUserService;


    public function __construct(VerifyUserService $verifyUserService)
    {
        $this->verifyUserService = $verifyUserService;
    }

    public function verifyUser(VerifyUserRequest $request)
    {

        $user = Auth::user();

        if (!$user) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }
        $result = $this->verifyUserService->verify($user->id);

        if ($result['status'] === 'error') {
            return response()->json([
                'status' => 'error',
                'message' => $result['message']
            ], 400);
        }

        return response()->json([
            'status' => 'success',
            'message' => $result['message']
        ]);
    }
}
