<?php

namespace App\Http\Controllers\dashboard\transaction;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\transaction\DepositService;
use App\Http\Requests\DepositRequest;
use App\Models\Transaction;
class DepositController extends Controller
{
    public function handle(DepositRequest $request, DepositService $service)
    {
        return $service->processDeposit($request->validated(), auth()->user());
    }

   public function callback(Request $request, DepositService $depositService)
{
    $trackId = $request->query('trackId');
    $success = $request->query('success');

    if (!$trackId) {
        return response('شناسه تراکنش یافت نشد.', 400);
    }

    // Verify payment status with Zibal
    $verify = $depositService->verifyPayment($trackId);

    // Find transaction by trackId stored in metadata JSON column
    $transaction = Transaction::where('metadata->trackId', $trackId)->first();

    if (!$transaction) {
        return response('تراکنش یافت نشد.', 404);
    }

    if ($verify['success'] && $verify['status'] == 1 && $success == 1) {
        // Payment successful
        $transaction->status = 'completed';
        $transaction->external_id = $verify['data']['refNumber'] ?? null;
        $transaction->description = $verify['data']['description'] ?? $transaction->description;
        $transaction->save();

        // Increase wallet balance
        $wallet = $transaction->wallet;
        if ($wallet) {
            $wallet->balance += $transaction->amount;
            $wallet->save();
        }

        return response('پرداخت با موفقیت تکمیل شد.', 200);
    } else {
        // Payment failed or not verified
        $transaction->status = 'failed';
        $transaction->description = 'پرداخت ناموفق بوده یا لغو شده است.';
        $transaction->save();

        return response('پرداخت ناموفق بوده یا لغو شده است.', 400);
    }
}
}
