<?php

namespace App\Http\Controllers\Shared;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\Slider;
class SliderController extends Controller
{
    public function getSliders()
    {
        // پیدا کردن تنظیمات بر اساس ID
         $setting = Setting::Where('is_active',true)->first();

        // اگر تنظیمات پیدا نشد
        if (!$setting) {
            return response()->json(['error' => 'Setting not found'], 404);
        }

        // فرستادن اطلاعات اسلایدرها به فرانت‌اند
        $sliders = $setting->sliders->map(function ($slider) {
            return [
                'image' => $slider->image,
                'title' => $slider->title,
                'description' => $slider->description,
                'slug' => $slider->slug,
            ];
        });

        return response()->json(['sliders' => $sliders]);
    }
}
