<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Item;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Jobs\UpdateCryptoPricesJob;
use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;
use Illuminate\Support\Facades\Http;
use App\Services\shared\item\ItemService;
    class ItemController extends Controller
     {

     protected $itemService;

    public function __construct(ItemService $itemService)
    {
        $this->itemService = $itemService;
    }

    public function show_item($slug): JsonResponse
    {
        $item = $this->itemService->getItemBySlug($slug);

        if (!$item) {
            return response()->json(['message' => 'Item not found'], 404);
        }

        return response()->json(['data' => $item]);
    }

    public function landing_Featured()
    {
        $items = $this->itemService->getFeaturedItem();
        return response()->json(['data' => $items]);
    }

     public function getProductsByCategorySlug(string $slug): JsonResponse
    {
        $products = $this->itemService->getProductsByCategorySlug($slug);

        if ($products->isEmpty()) {
            return response()->json(['message' => 'Category not found or no products'], 404);
        }

        return response()->json(['data' => $products]);
    }


     }
