<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Jobs\UpdateCryptoPricesJob;
use GuzzleHttp\Client;
use Symfony\Component\DomCrawler\Crawler;
use Illuminate\Support\Facades\Http;
use App\Services\shared\category\CategoryService;
class CategoryController extends Controller
{
    public function tree(): JsonResponse
       {
            // گرفتن دسته‌هایی که والد ندارند (یعنی parent_id == null)
           // به همراه بارگذاری eager رابطه children (زیرشاخه‌ها)
           $categories = Category::with('children')->whereNull('parent_id')->get();

           return response()->json($categories);
       }

      public function show_cat($slug, CategoryService $categoryService)
        {
           $data = $categoryService->getCategoryPageWithSeo($slug);
           if (!$data) {
             return response()->json(['error' => 'Category not found'], 404);
           }
           return response()->json($data);
        }

    public function fetchRates()
       {
             $response = Http::get('https://call3.tgju.org/ajax.json?rev=yd1frebfcHWFyYjIhBUdNwoeOuCcSDrEFbdwpgsl9g2iJOo9XgtDOvRZGfT1'); // آدرس واقعی رو جایگزین کن
             $prices = $response->json();
             return $prices; // یا هر کاری که خواستی بکن
       }
}
